package floweditor.system;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.StringReader;
import java.io.FileNotFoundException;
import java.io.IOException;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Container;
import java.awt.BorderLayout;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;   

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JFrame;

import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;

import floweditor.component.CompFactory;
import floweditor.component.NotWellFormedDocument;
import floweditor.util.Log;

class TopWindow extends JFrame implements ActionListener {

    
/* In diesem Frame, soll der Benutzer die Moeglichkeit haben neue Workflows
   zu erzeugen und schon existierende WF zu aendern|laden|loeschen, etc.
   karochi goboria eta Interface zw. Benutzer und System. Geplant ist
   dass der Frame folgendermasse aussehen sollte:

  i--------------------------------
  | --------------------------------|
  | +Model      | | Attr.| Graph|   |
  |  +WF1       |  -----------------|
  |  +WF2       |                   |
  |   +act2-1   |                   |
  |   +act2-2   |                   |
  |  +Part      |                   |
  |  +Data      |                   |
  |  ....       |                   |
  ` --------------------------------
*/   


    //String _emptyModelPath = "../../data/initialModel.xml";
    String _fileName = null;
    String _dirName;

    String _resourcePath     = "/floweditor";
    String _relativModelPath = _resourcePath + "/initialModel.xml";
    String _homePath         = null;

    Container contentPanel;

    /** */
    public TopWindow () {
	super ("FlowEditor");
	Log.file(1, "TopWindow", "TopWindow()");

	this.addWindowListener
            (
             new WindowAdapter ()
		 {
		     public void windowClosing (WindowEvent wevent)
                     {System.exit (0);}
		 }
             );

	this.setSize       (new Dimension (900, 600) );
        this.setLocation   (100, 200);
	this.setBackground (Color.white);
        /* hier kommen die Frame Komponenten
           Das MenuBar
        */
        this.addMenu ();

	/* FileChooser to load, save  or create? XML-Document
	 */

	_chooser = new JFileChooser ();
	_chooser.setFileFilter (new XMLFilter ());

	// FIXME
	FileSystemView filesystem = FileSystemView.getFileSystemView();
	File   homeDir = filesystem.getHomeDirectory();
	_homePath = homeDir.getPath();
	_chooser.setCurrentDirectory (new File(_homePath + _resourcePath) );

	Box box = new Box (BoxLayout.X_AXIS );
	contentPanel = getContentPane ();
	contentPanel.add (box, BorderLayout.CENTER);

	int nheight  = contentPanel.getPreferredSize().height;

        BoxLayout layout = new BoxLayout (contentPanel, BoxLayout.X_AXIS );

	_elemBox = new ElementBox (layout);
	_docBox  = new DocumentBox  (layout, _elemBox);

	box.add (_docBox);
	box.add (box.createHorizontalStrut(10));
	box.add (_elemBox);


	createEmptyModel ();
    }

    /** */
    private void addMenu () {

        JMenuBar menuBar = new JMenuBar ();
        setJMenuBar (menuBar);
        
        JMenu filesMenu = new JMenu ("Files");
        JMenu helpMenu  = new JMenu ("Help");
        
        menuBar.add     (filesMenu);
        menuBar.add     (helpMenu);
        
        JMenuItem newItem  = new JMenuItem ("load document");
        newItem.addActionListener (TopWindow.this);
        newItem.setActionCommand  ("load");    

        JMenuItem loadItem = new JMenuItem ("new document");
        loadItem.addActionListener (TopWindow.this);
        loadItem.setActionCommand  ("new");  
 
        JMenuItem saveItem = new JMenuItem ("save document");
        saveItem.addActionListener (TopWindow.this);
        saveItem.setActionCommand  ("save");  

        JMenuItem exitItem = new JMenuItem ("Exit");
        exitItem.addActionListener (TopWindow.this);
        exitItem.setActionCommand  ("exit");     
        
        filesMenu.add          (loadItem);
        filesMenu.add          (newItem);
	filesMenu.add          (saveItem);
        filesMenu.addSeparator ();
        filesMenu.add          (exitItem);      
        
    }

    /** Methoden fr die Erzeugung eines neuen Modells */
    public void createEmptyModel () {

	try {
	    String path = _homePath + _relativModelPath;
	    FileReader fileInput = new FileReader (path);
	    _docBox.readStream (fileInput, path);
	} catch (Exception e) {
	    System.err.println (e.getMessage ());
	    System.exit (1);
	}
	
    }

    /** */
    public void createDocument () {
	Log.file(1, "TopWindow", "createDocument()");       
	//_docBox.save ();
	createEmptyModel ();
    }

    /** Methoden fr das Laden eines bereits existierenden Dokumentes */
    public void loadDocumentTest (String fileName) {
	Log.file(1, "TopWindow", "loadDocument(String)");       

	FileReader fileInput = null; 

	try {
	    fileInput = new FileReader (fileName);
	    _docBox.readStream (fileInput, fileName);
	} catch (Exception e) {
	    System.err.println (e.getMessage ());
	}

    }

    /** Methode fr das Laden eines bereits existierenden Dokumentes*/
    public void loadDocument () {
	Log.file(1, "TopWindow", "loadDocument()");
     
	int state = _chooser.showOpenDialog (null);
	File file = _chooser.getSelectedFile ();
	
	if (file != null && state == JFileChooser.APPROVE_OPTION) {

	    try {
		FileReader reader = new FileReader (file);
		_docBox.readStream (reader, file.getPath());
		_fileName = file.getPath ();
		System.err.println (_fileName);
	    } catch (Exception e) {
		JOptionPane.showMessageDialog (null, 
			  "error while reading document\n" + e.getMessage());
	    }

	    //JOptionPane.showMessageDialog (null, file.getPath() );
  	    // loadDocument (file.getParent ());
	}

    }

    /** ber diese Methode wird das aktuelle Dokument gespeichert */
    public void saveDocument () {
	Log.file (1, "TopWindow", "saveDocument()");     
	int state = _chooser.showSaveDialog (null);
	File file = _chooser.getSelectedFile ();
	FileWriter out = null;
	// FIXME
	     
	if (file != null && state == JFileChooser.APPROVE_OPTION) {

	    try {
		out = new FileWriter (file);		
		_docBox.writeStream (out);
	    } catch (NotWellFormedDocument nwfd) {
		JOptionPane.showMessageDialog (null, 
			 "error while saving document \n" + nwfd.getMessage());
		_docBox.setFocus(nwfd.getComponent());
	    } catch (IOException io) {
		JOptionPane.showMessageDialog (null, 
			 "error while saving document \n" + io.getMessage());
	    } finally {
		try{
		    if (out != null)  out.close ();
		} catch (Exception e) {
		    // nop
		}
	    } 
       	}   // if
    }
    

    public void actionPerformed (ActionEvent e) {
	Log.file(1, "TopWindow", "actionPerformed (ActionEvent)");     
        String cmd = e.getActionCommand ();
        
        if (cmd.equals ("load")) {
	    Log.file(1,"TopWindow", "actionPerformed(ActionEvent)", "load");
	    loadDocument ();

        } else if (cmd.equals ("new")) {
            
	    Log.file(1,"TopWindow", "actionPerformed(ActionEvent)", 
		     "create Document");
	    createEmptyModel ();

	} else if (cmd.equals ("save")) {

	    Log.file(1,"TopWindow", "actionPerformed(ActionEvent)", "saving");
	    saveDocument ();

        } else if (cmd.equals ("exit")) {
	    Log.file(1,"TopWindow", "actionPerformed(ActionEvent)", "exit");
	    System.err.println ("TopWindow::actionPerformed (ActionEvent)"
				+  " --> ASK FOR SAVING!! <-- ");
	    //            if (documentHasChanged()) { saveDocument (); }
            System.exit (0);
        }
    } 

    DocumentBox  _docBox;
    ElementBox   _elemBox;
    JFileChooser _chooser;

    /* interne Klasse filtert nur XML-Dokumente
     */

    class XMLFilter extends FileFilter {

	public boolean accept (File  f) {

	    boolean accept = f.isDirectory ();

	    if (!accept) {

		String suffix = getSuffix (f);
		if (suffix != null) {
		    accept = suffix.equals ("xml");
		}
	    }
	    return accept;
	}
	
	public String getDescription () {
	    return "XML-Documents(*.xml)";
	}

	private String getSuffix (File f) {

	    String s      = f.getPath ();
	    String suffix = null;
	    
	    int i    = s.lastIndexOf (".");
	    
	    if (i > 0 && i < s.length () -1) {
		
		suffix = s.substring (i+1);
		// in case we want to have also *.XML Files: 
		// s.substring (i+1).toLowerCase ();
	    }
	    return suffix;
	}
    }

}






