package floweditor.system;

import floweditor.util.Log;
import java.io.File;
import java.io.FileWriter;

import javax.swing.filechooser.FileSystemView;

class Main {
    //Main () {}


    public static boolean manageResourceDirectory()
    {
	FileSystemView filesystem = FileSystemView.getFileSystemView();
	File homeDir          = filesystem.getHomeDirectory();
	File sourceDir        = new File(homeDir.getPath() + "/floweditor");
	File defaultModelFile = new File(homeDir.getPath() + "/floweditor/initialModel.xml");
	File dtdFile          = new File(homeDir.getPath() + "/floweditor/wfcl.dtd");

	try {
	    if (!sourceDir.exists()) {
		sourceDir.mkdir();
	    }
       
	    if (!defaultModelFile.exists()) {
		FileWriter writer = new FileWriter(defaultModelFile);
		writer.write(DEFAULT_MODEL);
		writer.close();
	    }

	    if (!dtdFile.exists()) {
		FileWriter writer = new FileWriter(dtdFile);
		writer.write(DEFAULT_DTD);
		writer.close();
	    }
	    return true;
	} catch (Exception e) {
	    return false;
	}
    }

    public static void main (String [] args) {
	Log.file(1, "Main","main(String[]");
		    
	//System.out.println ("lese: " + args[0] + " in den Parser ein");
	//String fileName = args [0];
	
	if (!manageResourceDirectory()) {
	    System.err.println("Error: could not create directory ~/floweditor/\n");
	    System.exit(-1);
	}

        TopWindow topWindow = new TopWindow();
	/*
	if (fileName.length ()!= 0) {

	    topWindow.loadDocument (fileName);
	}
	*/
        topWindow.setVisible (true);   
    }

    private static  String DEFAULT_MODEL 
	=  "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n"
	+  "<!DOCTYPE MODEL SYSTEM \"wfcl.dtd\">\n"
	+  "<MODEL ID=\"id_1\" />\n";

    private static String DEFAULT_DTD 
	= "<?xml version=\"1.0\" encoding=\"UTF-8\"?> "
	+ "<!-- Entitiy definitions to make stupid stuff -->\n"
	+ "<!ENTITY % OptRequired      \"#IMPLIED\">\n"
	+ "<!ENTITY % Required         \"#REQUIRED\">\n"
	+ "<!ENTITY % Optional         \"#IMPLIED\">\n"
	
	+ "<!ENTITY % Identifier       \"ID\">\n"
	+ "<!ENTITY % IdRef            \"IDREF\">\n"
	+ "<!ENTITY % String           \"CDATA\">\n"
	+ "<!ENTITY % Date             \"CDATA\">\n"
	+ "<!ENTITY % Unit             \"CDATA\">\n"
	+ "<!ENTITY % Cardinal         \"CDATA\">\n"
	+ "<!ENTITY % Priority         \"CDATA\">\n"
	+ "<!ENTITY % Duration         \"CDATA\">\n"
	+ "<!ENTITY % Cost             \"CDATA\">\n"
	+ "<!ENTITY % Classification   \"CDATA\">\n"
	
	+ "<!ENTITY % Reference        \"CDATA\">\n"
	+ "<!ENTITY % Mode             \"(AUTOMATIC|MANUAL)\">\n"
	+ "<!ENTITY % Version          \"%String;\">\n"
	+ "<!ENTITY % Name             \"%String;\">\n"
	+ "<!ENTITY % ModelId          \"%Identifier;\">\n"
	+ "<!ENTITY % ParticipantId    \"%Identifier;\">\n"
	+ "<!ENTITY % ParticipantType  \"(ORGANIZATIONAL-UNIT|HUMAN|ROLE|SYSTEM)\">\n"
	+ "<!ENTITY % ParticipantRef         \"%IdRef;\">\n"
	+ "<!ENTITY % ParticipantAssignment  \"%IdRef;\">\n"
	+ "<!ENTITY % DataId                 \"%Identifier;\">\n"
	+ "<!ENTITY % ApplicationId          \"%Identifier;\">\n"
	+ "<!ENTITY % ProcessId              \"%Identifier;\">\n"
	+ "<!ENTITY % ProcessRef             \"%IdRef;\">\n"
	+ "<!ENTITY % TransitionId           \"%Identifier;\">\n"
	+ "<!ENTITY % ActivityId             \"%Identifier;\">\n"
	+ "<!ENTITY % ActivityRef            \"%IdRef;\">\n"
		
	+ "<!ENTITY % DataType         \"%String;\">\n"
	+ "<!ENTITY % DataValue        \"%String;\">\n"
		
	+ "<!ENTITY % Condition        \"%String;\">\n"
		
	+ "<!ENTITY % ParticipantsApplicationsData \"(PARTICIPANT|APPLICATION|DATA)*\">\n"
		
		+ "<!ENTITY % RedefinableHeader \n"
		+ "\"     AUTHOR        %String;                             %Optional; \n"
		+ "      VERSION       %Version;                            %Optional; \n"
		+ "      CHARACTERSET  %String;                             %Optional; \n"
		+ "      CODEPAGE      %String;                             %Optional; \n"
		+ "      COUNTRY-KEY   %String;                             %Optional; \n"
		+ "      RESPONSIBLE   %ParticipantAssignment;              %Optional; \n"
		+ "      STATUS        (under-revision|released|under-test) %Optional; \n"
		+ "\">\n"

		+ "<!ENTITY % TimeEstimation \n"
		+ " \"       WAITING-TIME  %Duration;       %Optional; \n"
		+ "         WORKING-TIME  %Duration;       %Optional; \n"
		+ "         DURATION      %Duration;       %Optional; \n"
		+"\">\n"

		+ "<!ENTITY % ExecMode \"(ASYNCHR|SYNCH)\">\n"
		+ "<!ENTITY % LoopKind \"(WHILE|REPEAT-UNTIL)\">\n"

		+ "<!ELEMENT DESCRIPTION  (#PCDATA)>\n"

		+ "<!ELEMENT MODEL ( \n"
		+ "          DESCRIPTION?, \n"
		+ "          %ParticipantsApplicationsData;, \n"
		+ "          WORKFLOW* \n"
		+ ")>\n"
		
		+ "<!ATTLIST MODEL \n"
		+ "          ID                  %ModelId;     %Required; \n"
	+ "          NAME                %Name;        %Optional; \n"
	+ "          DOCUMENTATION       %Reference;   %Optional; \n"
	+ "          WPDL_VERSION        %String;      %OptRequired; \n"
	+ "          VENDOR              %String;      %OptRequired; \n"
	+ "          CREATED             %Date;        %OptRequired; \n"
	+ "          PRIORITY-UNIT       %Unit;        %Optional; \n"
	+ "          COST-UNIT           %Unit;        %Optional; \n"
	+ "          %RedefinableHeader; \n"
	+ ">\n"
		
	+ "<!ELEMENT PARTICIPANT ( \n"
	+ "          DESCRIPTION? \n"
	+ ")>\n"
		
	+ "<!ATTLIST PARTICIPANT \n"
	+ "          TYPE       %ParticipantType;  %Required;     \n"  
	+ "          NAME       %Name;             %Optional; \n"
	+ "          MAIL       %String;           %Optional; \n"
	+ "          ID         %ParticipantId;    %Required; \n"
	+ "          PARAM      %String;           %Optional; \n"
	+ ">\n"
		
	+ "<!ELEMENT APPLICATION ( \n"
	+ "          DESCRIPTION?, \n"
	+ "          PARAMETER* \n"
	+ ")>\n"
	+ "<!ATTLIST APPLICATION \n"
	+ "          PARAM      %String;           %Optional; \n"
	+ "          ID         %ApplicationId;    %Required; \n"
	+ "          NAME       %Name;             %Optional; \n"
	+ "          TOOLNAME   %String;           %Optional; \n"
	+ ">\n"
		
	+ "<!ELEMENT PARAMETER EMPTY>\n"
		
	+ "<!ATTLIST PARAMETER \n"
	+ "          NAME       %Name;             %Required; \n"
	+ "          TYPE       %DataType;         %Required; \n"
	+ ">\n"
	+ "<!ELEMENT DATA ( \n"
	+ "          DESCRIPTION?, \n"
	+ "          (PARTICIPANT|APPLICATION|ARGUMENT) \n"
	+ ")>\n"
		
	+ "<!ATTLIST DATA  \n"
	+ "          ID                %DataId;          %Required; \n" 
	+ "          NAME              %Name;            %Optional; \n" 
	+ "          WORKFLOW          %String;          %Required; \n"
	+ "          TYPE              %DataType;        %Required; \n"
	+ "          LENGTH            %Cardinal;        %Optional; \n"
	+ "          DEFAULT-VALUE     %DataValue;       %Optional; \n"
	+ ">\n"
		
	+ "<!ELEMENT WORKFLOW ( \n"
	+ "          DESCRIPTION?, \n"
	+ "          %ParticipantsApplicationsData;, \n"
	+ "          (ACTIVITY|TRANSITION)* \n"
	+ ")>\n"
		
	+ "<!ATTLIST WORKFLOW \n"
	+ "          ID                %ProcessId;       %Required; \n"
	+ "          NAME              %Name;            %Optional; \n"
	+ "          LOC               %String;          %Required; \n"
	+ "          CREATED           %Date;            %Optional; \n"
	+ "          DURATION-UNIT     (Y|M|D|h|m|s)     %Optional; \n"
	+ "          PRIORITY          %Priority;        %Optional; \n"
	+ "          LIMIT             %Duration;        %Optional; \n"
	+ "          VALID-FROM        %Date;            %Optional; \n"
	+ "          VALID-TO          %Date;            %Optional; \n"
	+ "          %TimeEstimation; \n"
	+ "          CLASSIFICATION    %Classification;  %Optional; \n"
	+ "          DOCUMENTATION     %Reference;       %Optional; \n"
	+ ">\n"
		
	+ "<!ELEMENT ACTIVITY ( \n"
	+ "          DESCRIPTION?, \n"
	+ "          (NOIMPLEMENTATION|APPLICATIONS|SUBFLOW|LOOP), \n"
	+ "          ACCESSRESTRICTION?, \n"
	+ "          TRANSITIONRESTRICTION? \n"
	+ ")>\n"
		
	+ "<!ATTLIST ACTIVITY \n"
	+ "          ID               %ActivityId;      %Required; \n"
	+ "          NAME             %Name;            %Optional; \n"
	+ "          DOCUMENTATION    %Reference;       %Optional; \n"
	+ ">\n"
	+ "<!ENTITY  % ImplementationAttributes  \n"
	+ "\"         PERFORMER          %ParticipantRef;   %Optional; \n" 
	+ "          START-MODE         %Mode;             %Optional; \n"
	+ "          FINISH-MODE        %Mode;             %Optional; \n"
	+ "          PRIORITY           %Priority;         %Optional; \n"
	+ "          DOCUMENTATION      %Reference;        %Optional; \n"
	+ "          INSTANTIATION      (ONCE|MULTIPLE)    %Optional; \n"
	+ "          %TimeEstimation; \n"
	+ "          COST-ESTIMATION    %Cost;             %Optional; \n"
	+ "\">\n"
		
	+ "<!ELEMENT NOIMPLEMENTATION EMPTY>\n" 
	+ "<!ATTLIST NOIMPLEMENTATION \n"
	+ "          %ImplementationAttributes; \n"
	+ ">\n"
		
	+ "<!ELEMENT APPLICATIONS ( \n"
	+ "          TOOL* \n"
	+ ")>\n"
		
	+ "<!ATTLIST APPLICATIONS  \n"
	+ "          %ImplementationAttributes; \n"
	+ ">\n"
		
		
	+ "<!ELEMENT TOOL ( \n"
	+ "          ARGUMENT* \n"
	+ ")>\n"
	+ "<!ATTLIST TOOL \n"
	+ "          PARAM     %String;      %Optional; \n"
	+ "          NAME      %String;      %Required; \n"
	+ ">\n"
		
	+ "<!ELEMENT ARGUMENT EMPTY>\n"
	+ "<!ATTLIST ARGUMENT \n"
	+ "          PARAM     %String;      %Optional;  \n"
	+ "          TYPE      %String;      %Required; \n"
	+ "          VALUE     %String;      %Required; \n"
	+ ">\n"
		
	+ "<!ELEMENT SUBFLOW EMPTY>\n"
	+ "<!ATTLIST SUBFLOW \n"
	+ "          %ImplementationAttributes; \n"
	+ "          REF                      %ProcessRef; %Required; \n"
	+ "          EXEC                     %ExecMode;   %Optional; \n"
	+ ">\n"
		
	+ "<!ELEMENT LOOP EMPTY>\n"
	+ "<!ATTLIST LOOP \n"
	+ "          %ImplementationAttributes; \n"
	+ "          KIND           %LoopKind;      %Required; \n"
	+ "          CONDITION      %Condition;     %Required; \n"
	+ ">\n"
	+ "<!ELEMENT ACCESSRESTRICTION EMPTY>\n"
		
	+ "<!ELEMENT TRANSITIONRESTRICTION EMPTY>\n"
	+ "<!ATTLIST TRANSITIONRESTRICTION \n"
	+ "          JOIN         (AND|XOR)        %Optional; \n"
	+ "          SPLIT        (AND|XOR)        %Optional; \n"
	+ "          TRANSITIONS  %String;         %Optional; \n"
	+ ">\n"
		
	+ "<!ELEMENT TRANSITION ( \n"
	+ "          DESCRIPTION? \n"
	+ ")>\n"
	+ "<!ATTLIST TRANSITION \n"
	+ "          ID           %TransitionId;   %Required; \n"
	+ "          NAME         %Name;           %Optional; \n"
	+ "          FROM         %ActivityRef;    %Required; \n"
	+ "          TO           %ActivityRef;    %Required; \n"
	+ "          CONDITION    %Condition;      %Optional; \n"
	+ "          LOOP         (FROM|TO)        %Optional; \n"
	+ ">\n";

}
