package floweditor.pool.MODEL.WORKFLOW;

import java.awt.Dimension;
import java.awt.Color;
import java.awt.Point;
import java.awt.Graphics;
import java.awt.AWTEvent;
import java.awt.FlowLayout; 
import java.awt.BorderLayout;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent; 
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent; 
import java.awt.event.MouseEvent;

import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JRadioButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.JTree;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.DefaultTreeModel;

import com.ibm.xml.parser.TXElement;

import com.ibm.graph.Net;
import com.ibm.graph.ext.visual.VisualVertex; 
import com.ibm.graph.ext.visual.VisualEdge;

import floweditor.component.Component;
import floweditor.component.CompFactory;
import floweditor.component.CompGraph;
import floweditor.component.CompGraphEditor;

import floweditor.component.NotWellFormedDocument;

import floweditor.util.EdgeType;
import floweditor.util.TopologicalSort;
import floweditor.util.Topology;
import floweditor.util.Log;



import floweditor.pool.MODEL.TRANSITION.TRANSITION;
import floweditor.pool.MODEL.ACTIVITY.ACTIVITY;

/** 
    Diese Klasse stellt ein graphisches Editor fr WORKFLOW-Objekte dar. 
 */
public class WorkflowGraphEditor 
    extends CompGraphEditor 
    implements ItemListener 
{
	
    JButton      _addActivity;
    JRadioButton _addTransition, _removeElement;
    ButtonGroup  _paintState;

    WORKFLOW     _workflow;
    Net          _wfgraph = new Net ();
    
    JPanel       _buttonPanel;
    PaintPanel   _paintPanel;

    DefaultTreeModel _treemodel;
    
    /** Ein graphisches Editor, um einen WorkflowGraph zu erstellen.
     */
    public WorkflowGraphEditor (Component workflow) 
    {
	super (workflow);	
	_workflow = (WORKFLOW) workflow;
	
	setLayout (new BorderLayout ());

	_paintPanel  = createPaintPanel  ();
	_buttonPanel = createButtonPanel ();
	
	JScrollPane _scrollPanel = new JScrollPane (_paintPanel);
	
	add ("Center", _scrollPanel);
	add ("South",  _buttonPanel);
    }	
    

    /** 
     *  Gibt die Malflche zurck, auf der die Komponenten
     *  des WORKFLOWS (Workflow-Graph) dargestellt/gemalt werden.
     */
    public PaintPanel createPaintPanel () 
    {
	PaintPanel paintPanel = new PaintPanel (50, 50, 140, 100);
	return paintPanel;
    }
    
    /** 
     *  Gibt Panel mit Knpfen zurck. Jeder Knpf stellt eine Funktionen dar,
     *  dass der Anwender auswhlen kann, um auf die Malflche zu arbeiten.
     */
    public JPanel createButtonPanel () 
    {
	JPanel buttonPanel     = new JPanel ();
	buttonPanel.setBackground (Color.cyan.darker ());
	buttonPanel.setLayout (new FlowLayout ());

	_paintState      = new ButtonGroup ();

	_addActivity     = new JButton ("new activity");	
	_addActivity.addActionListener (_paintPanel);
	_addActivity.setActionCommand  ("newact");

	_addTransition  = new JRadioButton ("draw transition");
	_addTransition.addItemListener     (this);
	_addTransition.setSelected         (false);

	_removeElement  = new JRadioButton ("remove element");
	_removeElement.addItemListener     (this);
	_removeElement.setSelected         (false);

	_paintState.add (_addTransition);
	_paintState.add (_removeElement);	
	
	buttonPanel.add (_addActivity);
	buttonPanel.add (_addTransition);
	buttonPanel.add (_removeElement);	
	
	return buttonPanel;
    }

    public void update () 
    {
	//nop
    }

    /** 
     */
    public void setTreeModel (DefaultTreeModel treemodel) 
    {
	_treemodel = treemodel;
    }

    final static int WAIT_FOR_PRESS = 0;
    final static int WAIT_FOR_RELEASE = 1;
    
    int _transSubState;          
    int _moveSubState;

    /**
     *  Falls der Anwender eine neue Funktion auswhlt, wird ber
     *  diese Methode der Zustand der Malflche (die zu diesem Zeitpunkt 
     *  genehmigte Aktion) gesetzt.
     */
    public void itemStateChanged (ItemEvent e) 
    {
	// user did chose another function
	// reset all substates
	    
	_transSubState = WAIT_FOR_PRESS;
	_moveSubState  = WAIT_FOR_PRESS;
    }

    /**
     *  Inner-Klasse, die Malflche fr WORLFLOW-Objekt darstellt.
     */
    private class PaintPanel  extends JPanel 
			      implements ActionListener
    {
	private Point     _last_p;
	private Point     _actual_p;

	private int       _dimCol;
	private int       _dimRow;
	
	private int       _nCols;
	private int       _nRows;
	private int       _cellWidth;
	private int       _cellHeight;
	final private int _lineThickness = 2;

	TopologicalSort   _sorter;

	/** Ein PaintPanel-Objekt wird instanziert, das in
	    nCols Spalten, nRows Reihen, geteilt ist. Jede Zelle
	    hat Breite cellWidht und Hhe cellHeight.
	 */
	public PaintPanel (int nCols, int nRows, 
			   int cellWidth, int cellHeight) 
	{
	    super (); 

	    _dimCol = nCols*cellWidth + (nCols + 1)*_lineThickness;
	    _dimRow = nRows*cellHeight + (nRows +1)*_lineThickness; 	

	    _cellWidth  = cellWidth;
	    _cellHeight = cellHeight;
	    _nCols = nCols;
	    _nRows = nRows;
	    
	    _sorter = new TopologicalSort ();

	    setPreferredSize (new Dimension (_dimCol, _dimRow));
	    enableEvents (AWTEvent.MOUSE_EVENT_MASK |  
			  AWTEvent.MOUSE_MOTION_EVENT_MASK);
	}

	/** Die "Malmethode".
	 */
	public void paint (Graphics g) 
	{
	    super.paint (g);
	    
	    paintGrid    (g);
	    paintWfGraph (g);
	}
	
	/**
	 *  Zeichnet diese Malflche als vergitterte Flche.
	 */
	public void paintGrid (Graphics g) 
	{

	    for (int col = 0; col <= (_nCols + 1); col++) {
		int posCol = col*(_cellWidth + _lineThickness);
		g.drawLine (posCol, 0, posCol, _dimRow);
	    }
	    
	    for (int row = 0; row <= (_nRows + 1); row++) {
		int posRow = row*(_cellHeight + _lineThickness);
		g.drawLine (0, posRow, _dimCol, posRow);
	    }
	    
	}

	/**
	 * Activities und Transitions werden hier gezeichnet.
	 */
	public void paintWfGraph (Graphics g) 
	{
	    TXElement[] activities  =  _workflow.searchChildrenAll ("ACTIVITY");
	    TXElement[] transitions =  _workflow.searchChildrenAll ("TRANSITION");

	    Topology  topology;

	    try {
		/* _sorter ordnet Komponenten an und liefert Topology
		 */
		topology = _sorter.sort (activities, transitions);
		
		/* Lege die Position fest, auf der die jeweilige Activity
		   dargestellt wird. */
		for (int i = 0; i < activities.length; i++) {
		    ACTIVITY     activity = (ACTIVITY) activities [i];
		    String       actId    = activity.getAttribute ("ID");
		    VisualVertex actGraph = 
			(VisualVertex) activity.getWkfElemGraph ();
		    
		    /* Zelle-koordinaten fr activity mit actId */
		    Point     cell       = topology.getPosition (actId);
		    Point     cellCentre = getCellCentre (cell.x, cell.y);
		    actGraph.setLocation (cellCentre);
		    _wfgraph.add (actGraph);
		}
		/* Mit den errechneten Positionen knnen die Transitions jetzt 
		   gezeichnet werden. */
		for (int j = 0; j < transitions.length; j++) {
		    TRANSITION  transition = (TRANSITION) transitions [j];
		    String      from = transition.getAttribute ("FROM");
		    String      to   = transition.getAttribute ("TO");
		    
		    ACTIVITY actFrom = (ACTIVITY) topology.getActivity (from);
		    ACTIVITY actTo   = (ACTIVITY) topology.getActivity (to);
		    transition.setEndGraphs (actFrom.getWkfElemGraph (),
					     actTo.getWkfElemGraph ());
		    EdgeType transType   = topology.getEdgeType (from, to);
		    if (transType._type == EdgeType.BACK_EDGES) {
			transition.setColor (Color.red); 
		    } else {
			transition.setColor (Color.blue);
		    }
		    VisualEdge transGraph = 
			(VisualEdge) transition.getWkfElemGraph ();
		    _wfgraph.add (transGraph);
		}
	    } catch (Exception e) {
		// shouldn't really happen
		e.printStackTrace ();
	    }		
	    
	    _wfgraph.draw (g);
	}

	/** Gibt den Mittelpunkt (die Koordinaten) der Zelle auf der 
	 *  Position Reihe col, Zeile row.
	 */
	public Point getCellCentre (int col, int row) 
	{
	    int colCenter 
		= col*(_cellWidth + _lineThickness)
		+ (_cellWidth / 2)
		+ (_lineThickness / 2);
	    int rowCenter 
		= row*(_cellHeight + _lineThickness) 
		+ (_cellHeight / 2)
		+ (_lineThickness / 2);
	    
	    return new Point (colCenter, rowCenter);
	}
	
	/** Ermittelt die Spalte, auf der ein Punkt pos 
	 *  sich befindet.
	 */
	public int getColumn (Point pos) 
	{
	    return (pos.x - _lineThickness)/(_cellWidth + _lineThickness); 
	}

	/** Ermittelt die Reihe, auf der ein Punkt pos 
	 *  sich befindet.
	 */
	public int getRow (Point pos) 
	{
	    return (pos.y - _lineThickness)/(_cellHeight + _lineThickness); 
	}
	
	/** Gibt den Mittelpunkt (die Koordinaten) der Zelle zurck, innerhalb 
	 *  deren sich ein Punkt pos befindet.
	 */
	public Point getCellCentreForPoint (Point pos) 
	{
	    int col = getColumn (pos);
	    int row = getRow (pos);

	    int colCenter 
		= col*(_cellWidth + _lineThickness)
		+ (_cellWidth / 2)
		+ (_lineThickness / 2);
	    int rowCenter 
		= row*(_cellHeight + _lineThickness) 
		+ (_cellHeight / 2)
		+ (_lineThickness / 2);

	    return new Point (colCenter, rowCenter);
	}
	
	/**
	 * berprft ob ein bestimmter Punkt p sich innerhalb der Graph-Instanz
	 * einer Activity befindet.
	 */
	public boolean CoordInActGraph (Point p) 
	{
	    boolean inActivity = false;
	    
	    for (Enumeration activities = _wfgraph.enumerateVertices (); 
		 activities.hasMoreElements () ; ) {
		
		VisualVertex act = (VisualVertex) activities.nextElement (); 
		if (act.contains (p.x, p.y)) {
		    inActivity =true;
		} else {
		    //nop
		}
	    }
	    return inActivity;
	}
	
	
	/**
	 * berprft ob ein bestimmter Punkt p sich innerhalb der Graph-Instanz
	 * einer Transition befindet.
	 */
	public boolean CoordInTransGraph (Point p) 
	{
	    boolean inTransition = false;
	    
	    for (Enumeration transitions = _wfgraph.enumerateEdges (); 
		 transitions.hasMoreElements () ; ) {
		
		VisualEdge trans = (VisualEdge) transitions.nextElement (); 
		if (trans.contains (p.x, p.y)) {
		    inTransition = true;
		} else {
		    //nop
		}
	    }
	    return inTransition;
	}
	
	/**
	 * Gibt die Activity-Graph zurck, innerhalb dessen einen 
	 * Punkt p sich befindet.
	 * @param p ein Punkt innerhalb eines Graph-Objekts
	 * @return actGraph das eine Instanz der Klasse VisualVertex darstellt.
	 */
	public VisualVertex getActGraphAt (Point p) 
	{
	    VisualVertex actGraphAt = null;

	    for (Enumeration activities = _wfgraph.enumerateVertices ();
		 activities.hasMoreElements() ; ) {
		
		VisualVertex actGraph = (VisualVertex) activities.nextElement();  
		if (actGraph.contains (p.x, p.y)) {
		    actGraphAt  = actGraph;
		}else {
		    //nop
		}
	    }
	    return actGraphAt;
	}
	
	/**
	 * Gibt die Transition-Graph zurck, innerhalb dessen einen 
	 * Punkt p sich befindet.
	 * @param p ein Punkt innerhalb eines Graph-Objekts
	 * @return transGraph das eine Instanz der Klasse VisualEdge darstellt.
	 */
	public VisualEdge getTransGraphAt (Point p) 
	{
	    VisualEdge transGraphAt = null;
	    //VisualVertex transGraphAt: berprfen ob es geht
	    for (Enumeration transitions = _wfgraph.enumerateEdges ();
		 transitions.hasMoreElements() ; ) {
		
		VisualEdge transGraph = (VisualEdge) transitions.nextElement();  
		if (transGraph.contains (p.x, p.y)) {
		    transGraphAt  = transGraph;
		}else {
		    //nop
		}
	    }
	    return transGraphAt;
	}
		
	/** Fgt eine ACTIVIY in den WORKFLOW (bzw. in den Workflow-Graph) ein.
	 */
	public void addActivity ()
	{
	    _wfgraph.clear ();

	    /* Eine neue Komponente der Sorte ACTIVITY wird erzeugt */
	    CompFactory factory  = (CompFactory) _workflow.getFactory();
	    Component   activity = (Component) factory.createElement ("ACTIVITY"); 
	    /* Die neue Komponente in der Liste der Workflow-Kinder einfgen */
	    _treemodel.insertNodeInto (activity, _workflow, 
				       _workflow.getChildCount ());

	    /* berprfe, ob die neue Komponente eine ID bentigt */
	    String idAttrName = activity.hasIdAttr ();
	    if (idAttrName != null) {      /* Komponente bentigt ID*/
		activity.lookupID (idAttrName); /* neue ID erzeugen und 
						   der Komponente zuweisen*/
	    }
	    
	}

	/**
	 * Fgt eine Kante mit den Endpunkten first und last. Voraussetzung dafr
	 * ist, dass sowohl first als auch last jeweils innerhalb eines Knoten
	 * befinden. Die Entsprechenden Knoten sollen unterschiedlich sein.	   
	 */
	public void addTransition (Point first, Point last) 
	{
	    
	    if ( CoordInActGraph(first) && CoordInActGraph (last) ) {

		CompGraph from = (CompGraph) getActGraphAt (first);
		CompGraph to   = (CompGraph) getActGraphAt  (last);
		
		if (from == to) {
		    // nop: es wird keine Linie gezeichnet
		    
		} else {
		    CompFactory factory  = (CompFactory) _workflow.getFactory();
		    Component transition = 
			(Component) factory.createElement ("TRANSITION"); 
		    
		    Component actFrom =  from.getComponent ();
		    Component actTo   =  to.getComponent ();

		    _wfgraph.clear ();
		    ((TRANSITION) transition).setEndRefs (actFrom.getAttribute("ID"), 
							  actTo.getAttribute("ID"));

		    _treemodel.insertNodeInto (transition, _workflow, 
					       _workflow.getChildCount ());
		
		    String idAttrName = transition.hasIdAttr ();
		    if (idAttrName != null) {
			transition.lookupID (idAttrName);
		    }		    
		    
		}		
		
	    } else  {
		;; System.out.println ("Transitions without activities " +
				       "won't be drawn!");
	    }
	}

	
	public void delObject (Point pos) {
	    
	    boolean actDeleted;
	    boolean transDeleted;

	    if (CoordInActGraph (pos)) {
		System.err.println ("coor in act? " + CoordInActGraph (pos));
		
		VisualVertex actGraph = getActGraphAt (pos);
		Component    activity = ((CompGraph) actGraph).getComponent();

		// Entferne ACTIVITY-Object samt TRANSITION-Objekte, die
		// mit dieser ACTIVITY zusammenhngen
		int i = 1;
		Enumeration transitions = actGraph.enumerateEdges ();
		Vector      transVector = new Vector ();
		while (transitions.hasMoreElements () ) { 

		    System.err.println ("lsche Transition: "+ i);
		    VisualEdge transGraph = (VisualEdge) transitions.nextElement ();
		 
		    Component trans = ((CompGraph) transGraph).getComponent ();
		    transVector.addElement (trans);
		    i++;
		    transDeleted = _wfgraph.remove (transGraph);
		    
		    //_workflow.remove (trans);
		    //_treemodel.removeNodeFromParent (trans);
		}

		_wfgraph.clear ();
		for (int j = 0; j < transVector.size (); j++) {
		    _treemodel.removeNodeFromParent 
			((Component) transVector.elementAt (j));
		    j++;
		}

		//actDeleted = _wfgraph.remove (toDelGraph);
		//Log.file(1, "Grapheditor", "deleteActivity (Point)2::");
		_treemodel.removeNodeFromParent (activity);	
		repaint ();
	    } else if (CoordInTransGraph (pos)) {
		System.err.println ("coor in trans? " + CoordInTransGraph (pos));
		VisualEdge transGraph = getTransGraphAt (pos);
		Component  transition = ((CompGraph) transGraph).getComponent ();
		//isDeleted = _wfgraph.remove (transGraph);
		_wfgraph.clear ();
		System.err.println("WORKFLOW hat " + 
				   _workflow.getChildCount() + 
				   " Kinderknoten");
		//_workflow.remove (trans);
		
		
		_treemodel.removeNodeFromParent (transition);
		System.err.println("WORKFLOW hat " + 
				   _workflow.getChildCount() + 
				   " Kinderknoten");	
		repaint ();
		
	    
	    } else { //nothing to delete 
		//transDeleted = false;
	    }
	    
	}
	
    
//  	  public void popAttrWindow (Point pos) {
	  
//  	  if (CoordInActGraph (pos)) {
	  
//  	  Activity act          = getActGraphAt (pos);
//  	  JFrame activityWindow = act.getElemWindow ();;
//  	  activityWindow.setLocation (pos.x, pos.y);
//  	  activityWindow.setVisible (true);
	  
//          } else if (CoordInTransGraph (pos)) {
	
//  	for (Enumeration transitions = _workflow.enumerateEdges (); 
//  	transitions.hasMoreElements () ; ) {
	
//  	Transition trans = ((Transition)transitions.nextElement ()); 
//  	if (trans.contains (pos.x, pos.y)) {
//  	System.err.println ("hier kommt Frame von Transition!");
//  	JFrame transWindow = trans.getElemWindow ();
//  	transWindow.setLocation (pos.x, pos.y);
//  	transWindow.setVisible (true);
//  	} else {
//  	//nop;;
//  	}   
//  		    }
//  		    } else {
//  		    //nop
//  		    System.err.println ("no activity or no transition: no Window");
//  		    }
//  	    }    
		
	/**
	 * 
	 */
	public void actionPerformed (ActionEvent e) 
	{
	    String cmd = e.getActionCommand ();
	    
	    if (cmd.equals ("newact")) {
		
		addActivity ();
		repaint ();
	    } else {
		
		//do nothing
	    }
	    
	}
	
	public void processMouseEvent (MouseEvent e) {
	    
	    if (e.getID () == MouseEvent.MOUSE_RELEASED) {
	    
		_actual_p = e.getPoint ();
		if (SwingUtilities.isRightMouseButton (e) ) {
		    
		    //popAttrWindow (_actual_p);
		    
		} else if (SwingUtilities.isLeftMouseButton (e)) { 
		    
		    if (_addTransition.isSelected ()) {
		    
			_transSubState = WAIT_FOR_PRESS;
			
			if ( _wfgraph.isEmpty ()){
			    
			    ;;System.out.println ("no activities, no transitions!");    
			} else {
			    addTransition (_last_p, _actual_p);
			    //;; System.err.println ("set _lineSubState to WAIT_FOR_PRESS ");
			repaint ();
			} 
			
		    } else {
			//nop
		    }
		}
		
	    } else if  (e.getID () == MouseEvent.MOUSE_PRESSED
			&& SwingUtilities.isLeftMouseButton (e) ) {
		
		_last_p   = e.getPoint ();
		_actual_p = e.getPoint ();
		
		if (_addTransition.isSelected ()) {
		    
		    _transSubState = WAIT_FOR_RELEASE;
		    //;; System.err.println ("set _lineSubState to WAIT_FOR_RELEASE ");
		    
//  		} else if (addActivity.isSelected ()) {
//  		    addActivity (_last_p);
//  		    repaint ();
		    
//  		} else if (moveActivity.isSelected ()) {
//  		_moveSubState = WAIT_FOR_RELEASE;
		
		} else if (_removeElement.isSelected ()) {
		    
		    if (_wfgraph.isEmpty ()) {
			System.err.println ("no objects to delete!");       
		    } else {
			delObject (_actual_p);
			repaint ();
		    } 
		} else {
		    System.err.println ("unknown State");
		}
	    } 
	else super.processMouseEvent (e);
	    
	}
	
	public void processMouseMotionEvent (MouseEvent e) {
	    
	    if (e.getID () == MouseEvent.MOUSE_DRAGGED) {         
		
		if (_addTransition.isSelected ()) {
		    
		    _actual_p = e.getPoint ();
		} else {
		    
		    System.err.println ("unknown State");  
		}
	    }
	    else super.processMouseEvent (e);
	}
    }    
}











