package floweditor.pool.MODEL.TRANSITION;

import java.awt.Color;
import java.util.Enumeration;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.tree.DefaultTreeModel;

import com.ibm.graph.ext.visual.VisualVertex;

import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.DTD;

import floweditor.util.Log;
import floweditor.component.Component;
import floweditor.component.CompForm;
import floweditor.component.CompAttributeEditor;
import floweditor.component.CompGraphEditor;
import floweditor.component.DefaultGraphEditor;
import floweditor.component.CompGraph;
import floweditor.component.DefaultGraph;

import floweditor.component.NotWellFormedDocument;
import floweditor.component.CompEventHandler;

import floweditor.pool.MODEL.WORKFLOW.WorkflowElemGraph;

public class TRANSITION 
    extends Component 
    implements WorkflowElemGraph
{

    /** Methode fr die Instanzierung einer Transition-Komponente.
     */
    public TRANSITION () 
    {
	super ("TRANSITION");
    }

    /** Legt die Referenzen auf Quell- bzw. Ziel-Activity fr die
	Transition fest.
	@param fromAct IDRef auf die Quell-Activity
	@param toAct IDRef auf die Ziel-Activity
     */
    public void setEndRefs (String from, String to) 
    {
	this.setAttribute ("FROM", from);
	this.setAttribute ("TO", to);
    }

    /** Setzt die Graphen, die fr diese Transition Quell- bzw. Ziel-Knoten 
	darstellen.
	@param fromGraph Darstellung der Quell-Activity
	@param toGraph   Darstellung der Ziel-Activity
     */
    public void setEndGraphs (CompGraph fromGraph, CompGraph toGraph) 
    {
	_fromGraph = fromGraph;
	_toGraph   = toGraph;
    }
    
    public void setColor (Color color) 
    {
	_color = color;
    }

    public void setEndPoints (Component fromAct, Component toAct) 
    {
	_fromAct = fromAct;
	_toAct   = toAct;
    }

    /** 
     * erzeugt eine GUI in Formularform, mit der Attribute und
     * Substrukturen manipuliert werden knnen      */
    public CompForm getCompForm (DefaultTreeModel treemodel)
    {
	if (_form == null) {
	    _form = new Formular ();
	}
	return _form;
    }

    /** 
     * gibt die graphische Instanz dieser Komponenten-Instanz
     * zurck. Mehrmalige Aufrufe geben immer das selbe Objekt zurck     */
    public CompGraph getCompGraph () 
    {
	if (_graph == null) {
            String idName = hasIdAttr();
            Color  color  = Color.red;
            if ( idName != null) {
                String label = getAttribute (idName);
                _graph = new DefaultGraph (this, label, color);
            } else {
                String label = getTagName ();
                _graph = new DefaultGraph (this, label, color);               
            }
	}
	return _graph;
    }
    
    
    //////////////////////////////////////////////////
    //        implements WorkflowElemGraph          //
    //////////////////////////////////////////////////
    /**
     * Gibt die graphische Instanz dieser Komponenten-Instanz
     * zurck. Mehrmalige Aufrufe geben immer das selbe Objekt zurck 
     * In Unterschied zu der Methode getCompGraph, gibt diese Methode
     * eine spezielle Darstellung dieser Instanz zurck, die fr die
     * Modellierung eines Workflow verwendet wird.*/
    public CompGraph getWkfElemGraph () 
    {
        if (_transGraph == null) {
	    _transGraph = new TransitionGraph (this, 
					       (VisualVertex) _fromGraph, 
					       (VisualVertex) _toGraph,
					       _color);            
        }
        return _transGraph;
    }
    
    /** definiert, welche Elemente diese Komponente nicht ber das
     * PopupMenu eingefgt bekommen mchte 
     * @see floweditor.component.DefaultPopupmenu
     *  */
    public  String[] getSuppressedPopupItems() 
    {
        String[] suppressedItems = {DTD.CM_PCDATA, 
				    DTD.CM_EOC, 
				    DTD.CM_ERROR};
        return suppressedItems;
    }

    /** Attribute einer Transition-Komponente
         ID exklusiver Name
         NAME beliebig, optional 
	 FROM ist IDREF auf Quelle-Activity, notwendig  
	 TO ist IDREF auf Ziel-Activity, notwendig
	 CONDITION beschreibt Bedingung fr Ausfhrung der Transition,
	                 optional
	 LOOP nimmt entweder den Wert "FROM" oder "TO", optional
	
     */
    String ID        = "ID";
    String NAME      = "NAME";
    String FROM      = "FROM";
    String TO        = "TO";
    String CONDITION = "CONDITION";
    String LOOP      = "LOOP";

    /** berschreibt die Methode in @see Component. Methode gibt ein 
     *  JComponent-Object zurck, die die Schnittstelle
     *  eines Attributes von dieser Komponente (TRANSITION) darstellt. 
     *  Fr Attribute die besondere Behandlung bentigen (also wenn 
     *  es sich um Attribute handelt, die nur bestimmte Werte 
     *  zugewiesen bekommen drfen) gibt es spezielle Klassen,
     *  die die jeweilige Schnittstelle darstellen.
     */
    public JComponent createAttributeField (AttDef attDef, String attrName) 
        throws floweditor.component.UnknownAttributeException
    {
	Log.file (1, "pool.MODEL.TRANSITION", "createAttributeField (String)");
	if (attrName.equals (FROM)) 
	    return new AttrFROM (this, attDef, 15);
	else if (attrName.equals (TO)) 
	    return new AttrTO (this, attDef, 15);
// 	else if (attrName.equals (LOOP))
// 	    return new AttrLOOP (this, attDef, 15); 
	else
	    return super.createAttributeField (attDef, attrName);
    }

    /** ber diese Methode werden alle EventHandler benachrichtigt,
     *  dass sie ihre Daten auf Konsistenz berprfen sollen (Nachricht
     *  wird propagiert).
     */
    public void checkForConsistency () 
        throws NotWellFormedDocument
    {
        DTD dtd  = getFactory().getDTD ();
        /* now do syntax-check */
        if ( hasChildNodes ()) {
            Enumeration children = this.children ();
            while (children.hasMoreElements () ){
                Component child    = (Component) children.nextElement ();
                 if (dtd.validate (child) == null) {
                    child.checkForConsistency ();
                } else {
                    //FIXME which Node is wrong? 
                    throw new NotWellFormedDocument ("Syntax error occured: " +
                                                     "Element "+child.getTagName()+
                                                     " wrong defined." +
                                                     " Attribute or child node" +
                                                     " missing.\n" +
                                                     "Unable to save",
                                                     child);
                }     
            }  /* end while */
        }  /* end if (1) */
        
        /* after correct syntax, check the semantics */
        Vector _handlerList = getEventHandler();
	int N = _handlerList.size();
	for(int i = 0; i < N; i++) {
	    CompEventHandler handler 
		= (CompEventHandler) _handlerList.elementAt(i);
	    handler.checkForConsistency ();
	}
    }

    /** Innere Klasse die das Form-Fenster der
	TRANSITION-Komponente definiert.
    */
    private class Formular 
	extends CompForm 
    {
	
	public Formular () 
	{
	    super ();

	    CompAttributeEditor attrEditor 
		= new CompAttributeEditor (TRANSITION.this);
	    JScrollPane panelOne = new JScrollPane (attrEditor);
	    
             graphEditor 
		= new DefaultGraphEditor (TRANSITION.this,
				       8, 8, 140, 100);
             panelTwo = new JScrollPane (graphEditor);

	    addToTabPane (panelOne, "TRANSITION ATTRIBUTES");
            addToTabPane (panelTwo, "TRANSITION GRAPHEDITOR");
	}

	public void checkData () 
	{
	    ;
	}

        /** Darstellung in GraphEditor aktualisieren wenn eine neue
            Kind-Komponente dazu gekommen ist.
         */
        public void update () 
	{
            graphEditor.update ();
        }

	JScrollPane     panelTwo; 
	CompGraphEditor graphEditor;
    }  

    Formular  _form       = null;
    CompGraph _graph      = null;
    CompGraph _transGraph = null;

    CompGraph _fromGraph;
    CompGraph _toGraph;
    Component _fromAct;
    Component _toAct;
    Color     _color;
}



