package floweditor.pool.MODEL.TRANSITION;

import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;


/**  Klasse, die ComboBox darstellt, auf der den Wert fr das Attribut
 *   TO (eine Referenz auf Activity-Component) eingetragen bzw. 
 *   ausgewhlt wird.  */
public class AttrTO
    extends javax.swing.JTextField
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;

    Component _wkf; //predecessor of owner;
    Component _refComp;  // which Component is referenced by 
    String    _wkfID; 

    boolean _isValid;
    
    public AttrTO (Component owner, AttDef attDef, int columns) 
    {
	// an TO must be set
	super (owner.getAttribute(attDef.getName()), columns);
	setEditable (false);
	_owner  = owner;
	_attDef = attDef;

        String  attributeName   = _attDef.getName();
        String  attributeValue  = _owner.getAttribute(attributeName);
        String  ownerName       = _owner.getTagName ();
        
        Log.file(1,"TRANSITION:Attr" + attributeName , 
                 "Attr"+attributeName + "(Component, AttDef, String)",
                 attributeName + "::" + 
                 attributeValue);
	// find ancestor workflow
	_wkf = (Component) _owner.searchAncestors ("WORKFLOW");

    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }
    
    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	// ignore
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	String attrValue = this.getText ();	
	if (attrValue == null || ((attrValue.trim()).length () == 0)) {
	    throw new NotWellFormedDocument ("TRANSITION.AttrTO \n" +
					     "Error: unknown target ACTIVITY1\n" +
					     "DELETE transition owning this " +
					     "attribute.",
					     _owner);
	} else {
	    Component comp = _owner.checkID (attrValue);
	    if (comp == null)
		throw new NotWellFormedDocument ("TRANSITION.AttrTO \n" +
						 "Error: value referenced at " +
                                                 "non existing Component! \n" +
						 "DELETE transition owning this"+
						 " attribute.",
                                                _owner);
	    
	    //FIXME
	    /* Topology test for ID-Owner */
	}
    }

}
