package floweditor.pool.MODEL.TOOL;

import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import java.util.Enumeration;

import javax.swing.JTextField;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;

/** abstract Klasse, von der sich alle weiteren AttributFelder
 *  ableiten */
public class AttrNAME
    extends javax.swing.JTextField
    implements CompEventHandler, FocusListener
{
    Component _owner;
    AttDef    _attDef;
    boolean _isValid;

    protected AttrNAME (Component owner, AttDef attDef, int columns) 
    {
	super (columns);
	_owner  = owner;
	_attDef = attDef;
	_isValid = false;

	String attributeName  = _attDef.getName ();
	String attributeValue = _owner.getAttribute (attributeName);

	this.setText (attributeValue);
	this.addFocusListener (this);

        Log.file(1,"TOOl.AttrNAME", 
                 "AttrNAME (Component, AttDef, String)",
                 attributeName + "::" +
                 attributeValue);
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore	
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrNAME", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setText(value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	String attrValue = this.getText ();
	if (attrValue == null || ((attrValue.trim()).length () == 0)) 
	    throw new NotWellFormedDocument ("TOOL.AttrNAME \n" +
					     "Error: no Name defined " +
                                             "for this PARAMETER! \n" +
                                             "Please enter a string",
					     _owner);
        
    }

    //////////////////////////////////////////////
    //       Implementation of FocusListener    //
    //////////////////////////////////////////////
    public void focusGained (FocusEvent event)
    {

    }

    public void focusLost (FocusEvent event)
    {
        String attributeName  =  _attDef.getName();
        String attributeValue = this.getText();

        if ((attributeValue.trim ()).length () == 0)
            _owner.setAttribute (attributeName, null);
        else
            _owner.setAttribute (attributeName, attributeValue);
        _owner.changeAttributeEvent ((CompEventHandler) this, 
                                     attributeName, 
                                     attributeValue);   
        Log.file (3,"TOOL::AttrNAME", 
                  "focusLost(FocusEvent)",
                  "attrvalue = " + attributeValue);
    }
}
