package floweditor.pool.MODEL.NOIMPLEMENTATION;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.TXElement;

import floweditor.component.CompFactory;
import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;

/** abstract Klasse, von der sich alle weiteren AttributFelder
 *  ableiten */
public class AttrPERFORMER
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    Component _refComp;  // which Component is referenced by 
    boolean   _isValid;
    static String NOVALUE = " --- ";

    protected AttrPERFORMER(Component owner, AttDef attDef, int columns) {
	// an ID must be set
	// FIXME
	super();
	_owner    = owner;
	_attDef   = attDef;
	_refComp  =  null;
	_isValid  = false;

	String attributeName  = _attDef.getName();
	String attributeValue = _owner.getAttribute (attributeName);
	String elementName    = _owner.getTagName();


	Log.file (1,"AttrPERFORMER","AttrPERFORMER (..) ", 
		  elementName + "::" +  
		  attributeName + "::" + 
		  attributeValue); 
	
	/* add Dummy-Field */
	this.addItem (NOVALUE);

	// Liste aller Komponenten der Sorte "PARTICIPANT"
	CompFactory factory = (CompFactory) _owner.getFactory ();
	Component parent = (Component) factory.getChildAt (0);
	TXElement [] participants = parent.searchDescendantsAll ("PARTICIPANT");
	for (int i = 0; i < participants.length; i++) {
	    String idValue = participants [i].getAttribute ("ID");
	    _isValid = _isValid || (idValue.equals (attributeValue));
	    this.addItem (idValue);
	}

	if (_isValid) {
	    this.setSelectedItem (attributeValue); 
	} else {
	     this.setSelectedIndex (0); 
        }
	
        this.addActionListener( new ActionListener () {
                public void actionPerformed(ActionEvent e) {
                    AttrPERFORMER  combobox = AttrPERFORMER.this;
                    Component component = combobox._owner;
                    String     attrName = (combobox._attDef).getName();
                    String attrValue 
                        = (String) combobox.getSelectedItem();
                    /* attribute got no value (only possible when 
                       attrType == IMPLIED) */
                    if (attrValue == NOVALUE) { 
			// no value for this attribute
                        component.setAttribute (attrName, null);
		    }
                    else 
                        component.setAttribute(attrName, attrValue);
                    component.changeAttributeEvent((CompEventHandler) combobox ,
                                                   attrName, 
                                                   attrValue);
                }
            }   );
	
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {

    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
        Log.file(1,"AttrPERFORMER", "attributeChangedEvent(..)");
        if ((_owner == owner) && (attrname == _attDef.getName())){
            this.setSelectedItem(value);
        }

    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
        String attrValue = (String) this.getSelectedItem ();
        if ( attrValue.equals (NOVALUE)) { 
            // nothing to check
        } else {
           Component resp = _owner.checkID (attrValue);
           if (resp == null)
               throw new NotWellFormedDocument ("NOIMPL.AttrPERFORMER \n" +
                                                "Error: Participant with this ID " +
                                                "doesn't exist! \n" +
                                                "Please choose another ID",
                                                _owner);
       } // end if

    }


}
