package floweditor.pool.MODEL.MODEL;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;
import com.ibm.xml.parser.TXElement;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;

/** Klasse, die ComboBox darstellt, auf der den Wert fr das Attribut
 *  RESPONSIBLE eingetragen bzw, ausgewhlt wird.  */
public class AttrRESPONSIBLE
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    Component _refComp;  // which Component is referenced by 
    boolean   _isValid;
    private String NOVALUE = " none ";

    protected AttrRESPONSIBLE (Component owner, AttDef attDef, int columns) 
    {
	super();
	_owner    = owner;
	_attDef   = attDef;
	// FIXME who is't referenced Component?
	_refComp  =  null;
	_isValid  = false;

	String attributeName  = _attDef.getName();
	String attributeValue = _owner.getAttribute (attributeName);
	String elementName    = _owner.getTagName();


	Log.file (1,"AttrRESPONSIBLE","AttrRESPONSIBLE (..) ", 
		  elementName + "::" +  
		  attributeName + "::" + 
		  attributeValue); 

	/* add Dummy-Field */
	this.addItem (NOVALUE);
	// Liste aller Komponenten der Sorte "PARTICIPANT"
	TXElement [] participants = _owner.searchDescendantsAll ("PARTICIPANT");
	for (int i = 0; i < participants.length; i++) {
	    String idValue = participants [i].getAttribute ("ID");
	    _isValid = _isValid || (idValue.equals (attributeValue));
	    this.addItem (idValue);
	}

	if (_isValid) 
	    this.setSelectedItem (attributeValue); 
	else
	    this.setSelectedItem (NOVALUE);
	
        this.addActionListener( new ActionListener () {
                public void actionPerformed(ActionEvent e) {
                    AttrRESPONSIBLE  combobox = AttrRESPONSIBLE.this;
                    Component component = combobox._owner;
                    String     attrName = (combobox._attDef).getName();
                    String attrValue 
                        = (String) combobox.getSelectedItem();
                    /* attribute got no value (only possible when 
                       attrType == IMPLIED) */
                    if (attrValue.equals (NOVALUE)) { 
                        // no value for this attribute
                        component.setAttribute (attrName, null);
                    }
                    else 
                        component.setAttribute(attrName, attrValue);
                    component.changeAttributeEvent((CompEventHandler) combobox ,
                                                   attrName, 
                                                   attrValue);
                }
            }   );
	
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {

    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
        Log.file(1,"AttrRESPONSIBLE", "attributeChangedEvent(..)");
        if ((_owner == owner) && (attrname == _attDef.getName())){
            this.setSelectedItem(value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	String attrValue = (String) this.getSelectedItem ();
	if ( attrValue.equals (NOVALUE)) { 
	    // nothing to check
	} else {
	   Component resp = _owner.checkID (attrValue);
	   if (resp == null)
	       throw new NotWellFormedDocument ("MODEL.AttrRESPONSIBLE \n" +
						"Error: Participant with this ID " +
                                                "doesn't exist! \n" +
                                                "Please choose another ID",
						_owner);
       } // end if
	
    }


}
