package floweditor.pool.MODEL.LOOP;

import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import java.util.Enumeration;

import javax.swing.JTextField;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.component.Component;
import floweditor.component.CompEventHandler;
import floweditor.component.NotWellFormedDocument;

import floweditor.util.Log;

/** abstract Klasse, von der sich alle weiteren AttributFelder
 *  ableiten */
public class AttrCONDITION
    extends javax.swing.JTextField
    implements CompEventHandler, FocusListener
{
    Component _owner;
    AttDef    _attDef;
    boolean _isValid;

    protected AttrCONDITION (Component owner, AttDef attDef, int columns) 
    {
	super (columns);
	_owner  = owner;
	_attDef = attDef;
	_isValid = false;

	String attributeName  = _attDef.getName ();
	String attributeValue = _owner.getAttribute (attributeName);

	this.setText (attributeValue);
	this.addFocusListener (this);
	Log.file(1,"AttrCONDITION:", 
		 "AttrCONDITION (Component, AttDef, String)",
		 attributeName + "::" + 
                 attributeValue);
    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore	
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrCONDITION", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setText(value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
        Log.file (2, "LOOP.AttrCONDITION", "checkForConsistency()");
	String attrValue = this.getText ();
	if (attrValue == null || ((attrValue.trim()).length () == 0)) 
	    throw new NotWellFormedDocument ("LOOP.AttrCONDITION \n" +
					     "Error: no Condition defined! \n" +
					     "Please enter a value for " +
					     "this attribute",
					     _owner);
        
    }

    //////////////////////////////////////////////
    //       Implementation of FocusListener    //
    //////////////////////////////////////////////
    public void focusGained (FocusEvent event)
    {

    }

    public void focusLost (FocusEvent event)
    {
        String attributeName  =  _attDef.getName();
        String attributeValue = this.getText();

         if ((attributeValue.trim ()).length () == 0)
            _owner.setAttribute (attributeName, null);
        else
	    _owner.setAttribute (attributeName, attributeValue);
        _owner.changeAttributeEvent ((CompEventHandler) this, 
                                     attributeName, 
                                     attributeValue);   
        Log.file (3,"LOOP:AttrCONDITION", 
                  "focusLost(FocusEvent)",
                  "attrvalue = " + attributeValue);
    }

}
