package floweditor.component;

import java.awt.event.FocusListener;
import java.awt.event.FocusEvent;

import java.util.Enumeration;

import javax.swing.JTextArea;

import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.TXText;

import floweditor.util.Log;

/** Klasse, die Textfield darstellt, auf der den Wert des Attributes
 *  MAIL eingetragen bzw. dargestellt wird. 
 */
public class TextNodeField
    extends javax.swing.JTextArea
    implements CompEventHandler, FocusListener
{
    Component _owner;
    TXText    _text = null;
    String    _textValue;
    protected TextNodeField (Component owner, int rows, int columns) 
    {
        super (rows, columns);
        _owner  = owner;
	
	_text = (TXText) _owner.getFirstChild ();
	if (_text != null) {
	    _textValue = _text.getData ();
	    this.setText (_textValue);
        } else {
	    _text = new TXText ("");
	    //_owner.addTextElement (_text);
	}
	Log.file(1,"DESCRIPTION:", "TextNodeField (AttDef, String)");
    }
   
    public  void childRemovedEvent(Component owner, 
                                   Component child, 
                                   int index)
    {
        // ignore       
    }

    public  void childInsertedEvent(Component owner, 
                                    Component child, 
                                    int index)
    {
	Log.file(2,"TextNodeField", "childInsertedEvent(..)");	
    }

    public  void attributeChangedEvent(Component owner, 
                                       String attrname, 
                                       String value)
    {
        Log.file(2,"TextNodeField", "attributeChangedEvent(..)");
//         if ((_owner == owner) && (attrname == _attDef.getName())){
//             this.setText(value);
//         }
    }
    
    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	String value = this.getText ();
	if (value != null ||
	    (value.trim ()).length () != 0) {
	    _text.setData (value);
	    //    _owner.addTextElement (_text);
	} 
    }
    
    //////////////////////////////////////////////
    //       Implementation of FocusListener    //
    //////////////////////////////////////////////
    public void focusGained (FocusEvent event)
    {

    }

    public void focusLost (FocusEvent event)
    {
	String    value  =  this.getText();
	_text.setData (value);

	// FIXME: define another Method for this case
	// 	component.childInsertedEvent((CompEventHandler) textfield, 
	// 				       attributeName, 
	// 				       attributeValue);
	Log.file(1,"TextNodeField:", "focusLost (AttDef, String)");
    }
}
