package floweditor.component;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent; 

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

import floweditor.system.ElementBox;
import floweditor.util.Log;

/** Class InsertListener implements function "insert before"
    offered by PopupMenu
*/
public class InsertListener 
    implements ActionListener 
{
    private Component     _comp;
    private String        _label;
    private DefaultTreeModel _treemodel;
    private ElementBox _elembox;
    private JTree      _tree;
    private int        _row;
    
    public InsertListener (Component comp,
			   String label, 
			   JTree tree,
			   DefaultTreeModel treemodel,
			   ElementBox elembox,
			   int row) 
    {
	_comp      = comp;
	_label     = label;
	_treemodel = treemodel ;
        _elembox   = elembox;
        _tree      = tree;
        _row       = row;
    }
    
    public void actionPerformed (ActionEvent e) 
    {
	Component newComp = (Component) 
	    ((CompFactory) _comp.getFactory()).createElement (_label);
	Component parent = (Component) _comp.getParentNode();
	int       index = parent.getIndex (_comp);
	_treemodel.insertNodeInto (newComp, parent, index);
	_tree.expandRow (_row);
	_tree.setSelectionRow (_row);
        _elembox.changeContent (newComp.getCompForm (_treemodel));
    }
}
