package floweditor.component;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

import java.util.Enumeration;
import javax.swing.JComboBox;

import com.ibm.xml.parser.TXAttribute;
import com.ibm.xml.parser.DTD;
import com.ibm.xml.parser.AttDef;

import floweditor.util.Log;


/** abstract Klasse, von der sich alle weiteren AttributFelder
 *  ableiten */
public class AttrNameTokenGroup
    extends javax.swing.JComboBox
    implements CompEventHandler
{
    Component _owner;
    AttDef    _attDef;
    boolean   _isValid;
    static String  NOVALUE = "none";

    /** */
    protected AttrNameTokenGroup (Component owner, AttDef attDef, int columns) {
	// an ID must be set
	// FIXME
	super();
	_owner = owner;
	_attDef = attDef;
	_isValid = false;
	
	String  attributeName   = _attDef.getName();
	String  attributeValue  = _owner.getAttribute(attributeName);
	String  attDefaultValue = _attDef.getDefaultStringValue();
	String  ownerName       = _owner.getTagName ();
        Log.file(1, "AttrNameTokenGroup (..)",
		 ownerName + "::" +
                 attributeName + "::" + 
                 attributeValue);
	
	/* If attribute not required (attrtype == implied),
	   add Dummy-Field */
	this.addItem (NOVALUE);

	Enumeration enum = attDef.elements();
	while(enum.hasMoreElements()) {
	    String item = (String) enum.nextElement();
	    _isValid = _isValid || (item.equals(attributeValue));
	    this.addItem(item);
	}
	if (_isValid) {
	    this.setSelectedItem(attributeValue); 
	} else if (attDefaultValue != null) {
	    this.setSelectedItem(attDefaultValue); 
	} else {
	    this.setSelectedIndex(0); 
	}

	this.addActionListener( new ActionListener () {
		public void actionPerformed(ActionEvent e) {
		    AttrNameTokenGroup combobox = AttrNameTokenGroup.this;
		    Component component = combobox._owner;
		    String     attrName = (combobox._attDef).getName();
		    String attrValue 
			= (String) combobox.getSelectedItem();
		    /* attribute got no value (only possible when 
		       attrType == IMPLIED) */
		    if (attrValue == NOVALUE) { 
			component.setAttribute (attrName, "");
			attrValue = "";
		    }
		    else 
			component.setAttribute(attrName, attrValue);
		    component.changeAttributeEvent((CompEventHandler) combobox , 
						   attrName, 
						   attrValue);
		}
	    }   );

    }
   
    public  void childRemovedEvent(Component owner, 
				   Component child, 
				   int index)
    {
	// ignore
    }

    public  void childInsertedEvent(Component owner, 
				    Component child, 
				    int index)
    {
	// ignore
    }

    public  void attributeChangedEvent(Component owner, 
				       String attrname, 
				       String value)
    {
	Log.file(1,"AttrNameTokenGroup", "attributeChangedEvent(..)");
	if ((_owner == owner) && (attrname == _attDef.getName())){
	    this.setSelectedItem (value);
	}
    }

    public void checkForConsistency() 
        throws NotWellFormedDocument 
    {
	return;
    }

}
