package floweditor.component;
 
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent; 

import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

import floweditor.system.ElementBox;
import floweditor.util.Log;   

/** 
 * Class AppendListener implements function "append child"
 * offered by PopupMenu */
public class AppendListener 
    implements ActionListener 
{
    private Component _comp;
    private String    _label;
    private DefaultTreeModel _treemodel;
    private ElementBox _elembox;
    private JTree      _tree;
    private int        _row;

    public AppendListener (Component comp,
			   String label, 
			   JTree tree,
			   DefaultTreeModel treemodel,
			   ElementBox elembox,
			   int row) 
    {
	_comp      = comp;
	_label     = label;
	_treemodel = treemodel;
	_elembox   = elembox;
	_tree      = tree;
	_row       = row;
    }
    
    public void actionPerformed (ActionEvent e) 
    {
	Component newComp = (Component)
	    ((CompFactory) _comp.getFactory()).createElement (_label);
	_treemodel.insertNodeInto (newComp, _comp, _comp.getChildCount ());
	_tree.expandRow (_row);
	_tree.setSelectionRow (_row + _comp.getChildCount ());
	_elembox.changeContent (newComp.getCompForm (_treemodel));
    }
}
