package parser;

/**
 * Result is an utility class for the parser, that consits of a triplet
 * with the results of the actions produced by each step of the parser.
 * The triplet consists of an object variable with the code of the
 * generated expressions, a string variable with the code tree for 
 * debugging purpose and a JavaCodeTree, which consits of the expressions
 * in string form for code generation. 
 */
public class Result{

  /** The code with the generated expressions */
  public Object code;
  /** The syntax tree for the debugger */
  public String tree;
  /** The expressions in string form for the code generator */
  public JavaCodeTree javaCode;

 /**
  * Creates a new Result object, that consists of the given arguments
  *
  * @param newCode The code with the generated expression
  * @param newTree The syntax tree for the debugger
  * @param newJavaCode The expression in string form for the code generator
  */
  public Result(Object newCode, String newTree, JavaCodeTree newJavaCode){
 
    code = newCode;
    tree = newTree;
    javaCode = newJavaCode;
  }
}
