package dSelf;

/**
 * dSelfException is an exception, that is thrown whenever an error
 * occures in dSelf.
 */
public class dSelfException extends Exception{

  /** The description of the error. */
  protected String error = null;
  
  /** The name of the error. */
  protected String name = null;
  
 /**
  * Creates a new dSelf exception with this exception.
  */ 
  public dSelfException(Exception s){
  
    super(s.toString());
  }  

 /**
  * Creates a new dSelf exception with this error message.
  */ 
  public dSelfException(String s){
  
    super(s);
  }  

 /**
  * Creates a new dSelf exception.
  *
  * @param s The error message 
  * @param n The name of this error
  * @param e The description of this error
  */
  public dSelfException(String s, String n, String e){
  
    super(s);
    name = n;
    error = e;
  }  
  
 /**
  * Returns the name of this error.
  */  
  public String getName(){
  
    return name;
  }
  
 /**
  * Returns the description of this error.
  */  
  public String getError(){
  
    return error;
  }    
}
