package dSelf;

import java.io.Serializable;

/**
 * SlotDecl represents the declaration of a slot. It is used by the
 * parser.
 */
public abstract class SlotDecl implements Serializable{
 
  /** The name of the slot. */
  protected String slotName;

  /** The annotaion of the slot. */
  protected String annotation;

 /**
  * Returns the name of this slot.
  */ 
  public String getSlotName(){
  
    return slotName;
  }
  
 /**
  * Returns the annotation of this slot.
  */ 
  public String getAnnotation(){
    
    return annotation;
  }    

 /**
  * Sets a new annotation for this slot.
  */
  public void setAnnotation(String anno){
    
    annotation = anno;
  }    
  
 /**
  * Checks, if this slot is a parent slot.
  */ 
  public abstract boolean isParentSlot();
  
 /**
  * Checks, if the content of this slot is assignable.
  */ 
  public abstract boolean isAssignableSlot();

 /**
  * Checks, if this slot is an argument slot.
  */ 
  public abstract boolean isArgumentSlot();
}
