package dSelf;

import java.util.Vector;

/**
 * PrimitiveSO declares the interfaces and implements the methods,
 * that are shared by primitive data objects.
 */
public abstract class PrimitiveSO extends DataSO{

 /**
  * Returns the parent object of this primitive object
  */
  protected abstract LocalOrdinarySO getParent(); 

 
 /**
  * Returns the annotation for this object. For primitive objects
  * it's simply its name.
  */   
  protected String getAnnotation(){
  
    return getName();
  }   

 /**
  * Returns a clone of this object.
  */  
  public Object clone(){
  
    return this;
  }
       
 /** 
  * Returns the content of the slot with the specified name.
  *
  * @param slotName The name of the demanded slot
  * @return The content of the found slot or null if no one was found
  */
  public dSelfObject getSlotContent(String slotName){
 
    if(slotName.equals("parent"))
      return getParent();
      
    return null;  
  }
  
}
