package dSelf;

/**
 * NonLocalReturnException is thrown, when a non local return 
 * inside a method has been reached. It is forwarded to the object,
 * that has invoked the method.
 */
public class NonLocalReturnException extends Exception{

  /** The data object, that is returned by the method. */
  protected DataSO returnValue;

  /** The context block is declared */
  DataOrMethodSO context;
  
 /**
  * Creates a new return exception with the given object as its result.
  */ 
  public NonLocalReturnException(DataSO dSO, DataOrMethodSO target){
  
    returnValue = dSO;
    context = target;
  }  

 /**
  * Returns the result of the return expression.  
  */   
  public DataSO getReturnValue(){
  
    return returnValue;
  }

  /** Returns the target of non local return */
  public DataOrMethodSO getReturnTarget(){
    return context;
  }
}    
