package dSelf;

import java.util.Vector;

/**
 * MethodSO represents the method objects of dSelf.
 */
public class MethodSO extends DataOrMethodSO{
   
  /** The slots of this method object. */ 
  protected SlotVector slots;
  
  /** The code of this method object. */
  protected ExprList expressions;

  /** The link to the object, that invoked this method. */
  protected DataOrMethodSO self = null;  

  /** If this is used for a block. */
  protected boolean forBlock = false;
  
 /**
  * Creates a new method object  with the given slots and code.
  *
  * @param slotVec The slots for this object
  * @param expr The code for this object
  */   
  public MethodSO(SlotVector slotVec, ExprList expr){
  
    expressions = expr;
    slots = slotVec;
  }
 
  public MethodSO(SlotVector slotVec, ExprList expr, DataOrMethodSO context){
  
    expressions = expr;
    slots = slotVec;
    setContextForBlock(context);
  }

  protected void setContextForBlock(DataOrMethodSO context) {
    slots.addSlot(new ParentSlot("", context));
    this.self = context;
    forBlock = true;
  }
  
  protected boolean isForBlock() { return forBlock; }
  
 /** 
  * Returns the content of the slot with the specified name.
  *
  * @param slotName The name of the demanded slot
  * @return The content of the found slot or null if no one was found
  */
  public dSelfObject getSlotContent(String slotName){
  
    return slots.getSlotContent(slotName);
  }
   
 /**
  * Returns a vector with the contents of all parent slots.
  */
  public Vector getParentVector(){
  
    return slots.getParentVector();
  }  

 /**
  * Returns the slot vector of this data object.
  */
  public SlotVector getSlotVector(){
  
    return slots;
  }

 /**
  * Returns the code of this object.
  */  
  public ExprList getExpressionList(){
  
    return expressions;
  }
    
 /**
  * Returns a clone of this object.
  */  
  public Object clone(){
  
    return new MethodSO((SlotVector)slots.clone(), expressions);
  }

 /**
  * Returns the method activation object of this method object with
  * the given arguments and name.
  *
  * @param args The arguments of the method
  * @param name The name of the slot, where this method was located.
  * @return The method activation object for this method 
  */
  public MethodActivationSO getActivation(Vector args, String name) 
         throws dSelfException, NonLocalReturnException{

    return new MethodActivationSO((SlotVector)slots.clone(), expressions, args, name, self);
  }  

 /**
  * Returns the name of this object.
  */ 
  public String getName(){
  
    return "a method";
  }  

 /**
  * Evaluates the given dSelf object with the given arguments, that 
  * was found found in a slot with the given name and evaluates it
  * in the context of this object. 
  *
  * @param dSO The object, that shall be evaluated
  * @param args The arguments of the given object. 
  * @return The result of the evaluation of the given object
  */ 
  protected DataSO evalSO(dSelfObject dSO, Vector args, String messagename) 
            throws dSelfException, NonLocalReturnException{

    // Method objects aren't evaluated (only the MAO), so this method is never 
    // called.
    // Certainly it's not a good design to have such an unused method, but I
    // was in hurry at the end of my diploma thesis, sorry... :-(
    
    return new NilSO();
  }

 /**
  * The message dispatcher for primitive messages. It checks, if the
  * message is understood by this object. If yes, then the actions
  * of this are done, otherwise an error message is thrown.
  *
  * @param msg The primitive message, that is sent to this object
  * @return The result of the action, that was caused by the message
  */ 
  public DataSO dispatchPrimMsg(PrimMsg msg) 
         throws dSelfException, NonLocalReturnException{

    // Method objects aren't evaluated (only the MAO), so this method is never 
    // called.
    // Certainly it's not a good design to have such an unused method, but I
    // was in hurry at the end of my diploma thesis, sorry... :-(

    return new NilSO();
  }
}     
