package dSelf;

import java.util.Vector;

/**
 * MethodActivationSO represents the method activation object of dSelf.
 */
public class MethodActivationSO extends MethodSO{

  /** false after one execution */
  private boolean valid = true;
  
 /**
  * Creates a new method object  with the given slots, code and arguments.
  *
  * @param slots The slots for this object
  * @param expr The code for this object
  * @param args The arguments of this method
  * @param name The name of the slot, where the method was located
  */   
  public MethodActivationSO(SlotVector slots, ExprList expr, Vector args,
			    String name, DataOrMethodSO context)
    throws dSelfException, NonLocalReturnException{
  
    super(slots, expr);
    slots.initArgs(args, name);
    self = context;
    forBlock = (context == null)? false : true;
  }

  /** Find the non local return target */
  public DataOrMethodSO findReturnTarget() {
    DataOrMethodSO result = this;

    while ((result instanceof MethodActivationSO)
	   && ((MethodActivationSO)result).isForBlock())
      result = ((MethodActivationSO)result).self;

    return result;
  }

  public boolean isValid() { return this.valid; }
  public void makeInvalid() { this.valid = false; }
  
 /**
  * Executes this method within the given context.
  *
  * @param context The context of this method
  * @return The result of this method
  */ 
  public DataSO execute(DataOrMethodSO context) 
         throws dSelfException, NonLocalReturnException{

    if (! isForBlock()) {
      slots.addSlot(new ParentSlot("", context));
      self = context;
    }

    DataSO result;
    try {
      result = expressions.eval(this);
    }finally {
      makeInvalid();
    }

    return result;
  }
  
 /**
  * The message dispatcher for ordinary messages. It checks, if the
  * message is understood by this object. If yes, then the content of
  * the slot, that matches with the selector of the given message, is
  * returned. Otherwise the message is delegated to its parents by
  * using the lookup algorithm.
  *
  * @param msg The ordinary message, that is sent to this object
  * @return The content of the found slot
  */
  protected DataSO dispatchOrdinaryMsg(OrdinaryMsg msg) 
            throws dSelfException, NonLocalReturnException{

    if(msg.isResend())
      return self.dispatchOrdinaryMsg(msg);
   
    return super.dispatchOrdinaryMsg(msg);    
  }    
  
 /**
  * The message dispatcher for primitive messages. It checks, if the
  * message is understood by this object. If yes, then the actions
  * of this are done, otherwise an error message is thrown.
  *
  * @param msg The primitive message, that is sent to this object
  * @return The result of the action, that was caused by the message
  */ 
  public DataSO dispatchPrimMsg(PrimMsg msg) 
         throws dSelfException, NonLocalReturnException{
  
    return self.dispatchPrimMsg(msg);
  }
  
 /**
  * Evaluates the given dSelf object with the given arguments, that 
  * was found found in a slot with the given name and evaluates it
  * in the context of this object. 
  *
  * @param dSO The object, that shall be evaluated
  * @param args The arguments of the given object. 
  * @return The result of the evaluation of the given object
  */ 
  protected DataSO evalSO(dSelfObject dSO, Vector args, String messagename) 
            throws dSelfException, NonLocalReturnException{
    MethodActivationSO activation = null;

    try{
      if(dSO instanceof DataSO)  
        return (DataSO)dSO;

      if(dSO instanceof MethodSO){
        //return ((MethodSO)dSO).getActivation(args, messagename).execute(self);
	activation = ((MethodSO)dSO).getActivation(args, messagename);
	return activation.execute(self);
      }
 
      if (dSO instanceof AssignmentSO) {
	((AssignmentSO)dSO).setContent((DataSO)args.firstElement());
	//return (DataSO)self;
	return new NilSO();
      }

      throw new dSelfException("Internal error: " + dSO
			   + " is neither DataSO, nor MethodSO, nor AssignmentSO");
    }catch(NonLocalReturnException e){
      //System.err.println(this+" "+activation+"(in MethodActivationSO) catch NonLRE");
      if (activation == e.getReturnTarget())
	return e.getReturnValue();
      else
	throw e;
    }
  }

  /** Returns receiver of method or environment of block */
  public DataOrMethodSO getSelf()
  {
    return this.self;
  }
}
