package dSelf;

import java.rmi.*;
import java.util.Vector;
import dSelfVM;

/**
 * LocalOrdinarySO represents the ordinary dSelf objects located
 * on the local dSelf virtual machine.
 */
public class LocalOrdinarySO extends OrdinarySO{

 /** The slot vector for the slots of this object. */ 
  protected SlotVector slotVector = new SlotVector();
      
 /**
  * Creates a new, empty ordinary object.
  */     
  public LocalOrdinarySO(){}

 /**
  * Creats a new local ordinary object with the given slots and 
  * annotation.
  *
  * @param slots The new slots for this object
  * @param anno The annotation for this object
  */
  public LocalOrdinarySO(SlotVector slots, String anno){

    slotVector = slots;
    annotation = anno;
  }

 /**
  * Creats a new local ordinary object with the given slots.
  *
  * @param slots The new slots for this object
  */
  public LocalOrdinarySO(Slot slots){

    slotVector = new SlotVector(slots);
  }

 /**
  * Creats a new local ordinary object with the given annotation.
  *
  * @param anno The annotation for this object
  */
  public LocalOrdinarySO(String anno){
  
    annotation = anno;
  }  

 /**
  * Returns the name of this object. 
  */ 
  public String getName(){
  
    return annotation == null ? "an object" : annotation;
  }  

 /**
  * Adds a new slot to the existing ones. If there is already one 
  * with the same name, then the new slot replaces the the old slot.
  *
  * @param slot The new slot
  */
  public void addSlot(Slot slot){
 
    slotVector.addSlot(slot);
  }

 /**
  * Removes all slots of this objects.
  */ 
  protected void removeAllSlots(){
  
    slotVector.clearAllSlots();
  }

 /**
  * Removes the slot with the specified name. When no slot with
  * such name is found an exception is thrown
  *
  * @param remSlot The name of the slot
  */ 
  protected void removeSlot(String remSlot) throws dSelfException{  

    if(!slotVector.removeSlot(remSlot))    
      throw new dSelfException("Primitive \"_RemoveSlot:\" send to <"
          +getName()+"> failed, because slot \""+remSlot+"\" was not found !");
  }
  
 /**
  * Returns the slot vector of this data object.
  */
  public SlotVector getSlotVector(){
 
    return slotVector;
  }

 /**
  * Returns a vector with the contents of all parent slots.
  */
  public Vector getParentVector(){
  
    return slotVector.getParentVector();
  }  

 /** 
  * Returns the content of the slot with the specified name.
  *
  * @param slotName The name of the demanded slot
  * @return The content of the found slot or null if no one was found
  */
  public dSelfObject getSlotContent(String slotName){
 
    return slotVector.getSlotContent(slotName);
  }

 /**
  * Adds some slots to this object. If the given slot vector
  * has one or more slots with names, that already exist in this 
  * object, then the old slots with the same name will be removed.
  *
  * @param slots The slots, that will be added
  */
  protected void addSlots(SlotVector slots) throws dSelfException{
  
    slotVector.addSlotVector(slots);
  }
  
 /**
  * Adds some slots to this object. If the given slot vector
  * has one or more slots with names, that already exist in this 
  * object, then the new slots with the same name aren't added.
  *
  * @param slots The slots, that will be added
  */
  protected void addSlotsIfAbsent(SlotVector slots) throws dSelfException{
  
    slotVector.addSlotVectorIfAbsent(slots);
  }
}
