package dSelf;

/**
 * LocalAssignmentSO represents an assignment object, that is
 * located on this virtual machine.
 */
public class LocalAssignmentSO extends AssignmentSO{

  /** The data slot, to which this object refers. */
  protected DataSlot referingSlot;
  
 /**
  * Creates an new assignment object that refers to the given slot.
  *
  * @param A data slot, that shall be assignable
  */ 
  public LocalAssignmentSO(DataSlot refSlot){
  
    referingSlot = refSlot;
  }

 /**
  * Sets the reference of this object to another data slot.
  */ 
  public void setReferenceTo(DataSlot refSlot){

    referingSlot = refSlot; 
  }
  
 /**
  * Sets the new content of the slot, to which this assignment object
  * refers.
  *
  * @param content The data object for the data slot
  */ 
  protected void setContent(DataSO content){
  
    referingSlot.setContent(content);
  }
}
