package dSelf;

import java.util.Vector;

/**
 * ExprList represents a list of dSelf expressions. It is used as
 * the code of methods.
 */
public class ExprList implements CodeExpr{

  /** A vector with the expressions of this list. */
  public Vector expressions = null;
  
 /**
  * Creates a new empty expression list.
  */ 
  public ExprList(){
  
    expressions = new Vector();
  }  
  
 /**
  * Creates a new expression list with the given expression list plus 
  * the second argument.
  *
  * @param el A list of expressions
  * @param e A expression that is added to el
  */ 
  public ExprList(ExprList el, CodeExpr e){
  
    expressions = el.expressions;
    expressions.add(e);
  }

 /**
  * Creates a new expression list with the given expression list.
  *
  * @param e A expression that is added to el
  */ 
  public ExprList(CodeExpr e){
  
    expressions = new Vector();
    expressions.add(e);
  }

 /**
  * Evaluates all expressions of this list from left to right within 
  * the given context. Returns the result of the last evaluated 
  * expression.
  *
  * @param dSo The context, within this expressions are evaluated
  * @return The result of the last expression
  */    
  public DataSO eval(DataOrMethodSO selfContext) throws dSelfException, NonLocalReturnException{

    DataSO result = null;
    
    for(int i=0; i<expressions.size(); i++)
      result = ((CodeExpr)expressions.get(i)).eval(selfContext);
      
    return result;  
  }
}
