package dSelf;

import java.util.Vector;
import java.io.*;
import dSelfVM;

/**
 * BlockSO represents the block objects of dSelf.
 * BlockSO is a primitive dSelf object and so it has only one
 * parent slot called "parent", that is shared by all block objects.
 * The object, that "parent" refers to has initialy only one
 * parent slot, also called "parent" that refers to the lobby.
 * This object is dedicated to include the user-defined methods,
 * that are shared by all block objects.
 */
public class BlockSO extends PrimitiveSO{

 /** The shared parent object for all block objects */
  protected static LocalOrdinarySO parent = 
    new LocalOrdinarySO(new ParentSlot("parent", dSelfVM.lobbySO));

 /**
  * The shared slots for all block objects. It consists of only one slot
  * called "parent"
  */
  protected static SlotVector slotVector = 
    new SlotVector(new ParentSlot("parent",parent));   
    
 /**
  * The shared parent slots for all block objects. It consists of only one slot
  * called "parent"
  */
  protected static Vector parVector = new Vector();   
  
  static{
    parVector.add(parent);   
  }
 
  /** The block method object. */
  protected MethodSO blockMethodObject;
    
 /**
  * Creates a new block object with this block method object.
  *
  * @param m The block method object
  */   
  public BlockSO(MethodSO m){

    blockMethodObject = m;
  }

  protected void setContext(DataOrMethodSO context) {
    blockMethodObject.setContextForBlock(context);
  }
  
 /**
  * Returns the slots of the byte vectors. I.e, it's only one slot
  * called "parent".
  */   
  public SlotVector getSlotVector(){
    
    return slotVector; 
  }
  
 /**
  * Returns the shared parent slot for all dSelf byte vectors.
  */  
  protected LocalOrdinarySO getParent(){
  
    return parent;
  }
    
 /**
  * Returns the parent slots of the byte vectors. I.e, it's only one 
  * slot called "parent".
  */   
  public Vector getParentVector(){
  
    return parVector;
  }   

 /**
  * Returns the value of this byte vector in the form "byteVector(...)".
  */
  public String getName(){
  
    return "a block";  
  }  

 /**
  * Returns the block method object.
  */
  public MethodSO getMethod(){
  
    return blockMethodObject;
  }
    
  protected DataSO dispatchPrimMsg(PrimMsg msg) 
    throws dSelfException, NonLocalReturnException {

    if(msg.getMessageID() == PrimMsg.LOOP) {
      for (;;) {
	blockMethodObject.getActivation(msg.getArgs(), msg.getSelector()).execute(null);
      }
    }
    
    return super.dispatchPrimMsg(msg);
  }
    
  public Vector delegate(OrdinaryMsg msg) throws dSelfException{

    // If the search path debugger is activated show some informations  
    if(Globals.debug_searchPath)
      dSelfVM.printMessage("...search \""+msg.getSelector()+"\" in <"+getName()+":"+this+">");

    // Enter this object as a node on our search path. If the message reached
    // this object twice an alert will be returned.
    if(!msg.addVisited(this, getLocation())){
      throw new dSelfException("Message cycling detected with \""+msg.getSelector()+
                       "\" at "+getName());
    }

    msg.removeVisited(this, getLocation());
    
    // Look for a matching slot
    Vector resultVec = new Vector();
    
    if (Message.isBlockValueSelector(msg.getSelector())) {
      // A matching slot was found
      if(Globals.debug_searchPath)
        dSelfVM.printMessage("...found \"" + msg.getSelector() + "\" in <" +
	    getName() + ":" + this + ">");

      resultVec.add(new LookupResult(this, blockMethodObject));
    
      // We make a backtrack now, so remove this object from the list
      if(Globals.debug_searchPath)
	dSelfVM.printMessage("...make backtrack in <"+getName()+":"+this+">");
      
      return resultVec;	    
    }

    return super.delegate(msg);
  }
  
//  /**
//   * Evaluates this block within this context.
//   *
//   * @param context The context of this block
//   * @return The result of this block
//   */ 
//   public DataSO eval(DataOrMethodSO context){

//     return new BlockSO(context, (MethodSO) blockMethodObject.clone());
//   }
}
