package de.fu_berlin.inf.alp5.price;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

public class PriceEngineImpl extends PriceEnginePOA {

    private final List<Offer> offers = new Vector<Offer>();

    public void enter(Offer offer) {
        this.offers.add(offer);
    }

    public String[] list() {
        Set<String> articles = new HashSet<String>();
        for (Offer offer : this.offers) {
            articles.add(offer.article());
        }
        return articles.toArray(new String[articles.size()]);
    }

    public Offer bestOffer(String article) {
        Offer bestOffer = null;
        for (Offer offer : this.offers) {
            if (offer.article().equals(article)
                    && (bestOffer == null || bestOffer.price() > offer.price())) {
                bestOffer = offer;
            }
        }
        return bestOffer;
    }

}
