package de.fu_berlin.inf.alp5.price;

import java.rmi.Naming;
import java.util.Properties;

import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class PriceEngineClient {

    public static void main(String[] args) throws Exception {

        Properties props = new Properties();
        String host = args[0];
        String port = args[1];
        props.put("org.omg.CORBA.ORBInitialHost", host);
        props.put("org.omg.CORBA.ORBInitialPort", port);
        ORB orb = ORB.init(new String[0], props);

        org.omg.CORBA.Object namingRef = orb
                .resolve_initial_references("NameService");
        NamingContextExt naming = NamingContextExtHelper.narrow(namingRef);

        String name = args[2];
        org.omg.CORBA.Object priceEngineRef = naming.resolve_str(name);
        PriceEngine priceEngine = PriceEngineHelper.narrow(priceEngineRef);

        // operation
        String operation = args[3];
        if (operation.equalsIgnoreCase("articles")) {

            // print all articles
            String[] articles = priceEngine.list();
            if (articles == null || articles.length == 0) {
                System.out.println("No articles found");
            } else {
                System.out.println("Available articles:");
                for (String article : articles) {
                    System.out.println("  " + article);
                }
            }

        } else if (operation.equalsIgnoreCase("bestOffer")) {

            // name of the articles
            String article = args[4];

            // get best offer
            Offer offer = priceEngine.bestOffer(article);
            if (offer == null) {
                System.out.println("There are no articles with name: "
                        + article);
                return;
            }

            // print offer
            System.out.println("Best offer for " + offer.article());
            System.out.println("Vendor: " + offer.vendor());
            System.out.println("Price: " + offer.price());

        } else if (operation.equalsIgnoreCase("enter")) {

            // lookup for offer
            String offerName = args[4];
            org.omg.CORBA.Object offerRef = naming.resolve_str(offerName);
            Offer offer = OfferHelper.narrow(offerRef);

            // enter offer
            priceEngine.enter(offer);

        } else {

            System.out.println("Unknown operation: " + args[3]);

        }

    }

}
