package de.fu_berlin.inf.alp5.price;

import java.util.Properties;

import org.omg.CORBA.ORB;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAHelper;

public class OfferServer {

    public static void main(String[] args) throws Exception {

        Properties props = new Properties();
        String host = args[0];
        String port = args[1];
        props.put("org.omg.CORBA.ORBInitialHost", host);
        props.put("org.omg.CORBA.ORBInitialPort", port);
        ORB orb = ORB.init(new String[0], props);

        org.omg.CORBA.Object rootRef = orb
                .resolve_initial_references("RootPOA");
        POA root = POAHelper.narrow(rootRef);
        root.the_POAManager().activate();

        org.omg.CORBA.Object namingRef = orb
                .resolve_initial_references("NameService");
        NamingContextExt naming = NamingContextExtHelper.narrow(namingRef);

        String article = args[3];
        String vendor = args[4];
        float price = Float.parseFloat(args[5]);
        OfferImpl offer = new OfferImpl(article, vendor, price);

        org.omg.CORBA.Object serviceRef = root.servant_to_reference(offer);
        String name = args[2];
        NameComponent[] path = naming.to_name(name);
        naming.rebind(path, serviceRef);

        orb.run();

    }

}
