package de.fu_berlin.inf.alp5.price;

import java.util.Properties;

import org.omg.CORBA.ORB;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;

public class OfferClient {

    public static void main(String[] args) throws Exception {

        Properties props = new Properties();
        String host = args[0];
        String port = args[1];
        props.put("org.omg.CORBA.ORBInitialHost", host);
        props.put("org.omg.CORBA.ORBInitialPort", port);
        ORB orb = ORB.init(new String[0], props);

        org.omg.CORBA.Object namingRef = orb
                .resolve_initial_references("NameService");
        NamingContextExt naming = NamingContextExtHelper.narrow(namingRef);

        String name = args[2];
        org.omg.CORBA.Object offerRef = naming.resolve_str(name);
        Offer offer = OfferHelper.narrow(offerRef);

        System.out.println("Article: " + offer.article());
        System.out.println("Vendor: " + offer.vendor());
        System.out.println("Price: " + offer.price());

    }

}
