package de.fu_berlin.inf.alp5.logger;

import java.io.File;
import java.rmi.MarshalledObject;
import java.rmi.Naming;
import java.rmi.RMISecurityManager;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationGroupDesc.CommandEnvironment;
import java.util.Properties;

public class LoggerSetup {

    public static void main(String[] args) throws Exception {

        System.setSecurityManager(new RMISecurityManager());

        Properties pr = new Properties();
        pr.put("java.security.policy", args[1]);
        CommandEnvironment env = null;
        ActivationGroupDesc group = new ActivationGroupDesc(pr, env);
        ActivationGroupID groupID = ActivationGroup.getSystem().registerGroup(
                group);
        MarshalledObject data = new MarshalledObject(new File(args[2]));
        ActivationDesc desc = new ActivationDesc(groupID, LoggerImpl.class
                .getName(), "file:" + args[0], data);
        Logger logger = (Logger) Activatable.register(desc);
        System.out.println("LoggerImpl registered");

        Naming.rebind("//localhost/logger", logger);
        System.out.println("LoggerImpl bound");

    }

}
