package de.fu_berlin.inf.alp5.logger;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationID;
import java.util.List;
import java.util.Vector;

public class LoggerImpl implements Logger, Runnable {

    private final ActivationID id;

    private final File file;

    private final List<String> messages = new Vector<String>();

    public LoggerImpl(ActivationID id, MarshalledObject data)
            throws IOException, ClassNotFoundException {

        Activatable.exportObject(this, id, 0);

        this.id = id;
        this.file = (File) data.get();

        BufferedReader reader = new BufferedReader(new FileReader(this.file));
        String line;
        while ((line = reader.readLine()) != null) {
            this.messages.add(line);
        }
        reader.close();

        new Thread(this).start();

    }

    public void append(String m) {
        this.messages.add(m);
    }

    public String[] history() {
        return this.messages.toArray(new String[this.messages.size()]);
    }

    public void run() {
        try {

            while (true) {
                Thread.sleep(3000);
                BufferedWriter writer = new BufferedWriter(new FileWriter(
                        this.file));
                for (String m : this.messages) {
                    writer.write(m);
                    writer.write('\n');
                }
                writer.close();
                Activatable.inactive(this.id);
            }

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

}
